/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.managed;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.HwmcaObjectProperties;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.util.Trace;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class HwmcaObject
implements Persistable,
HwmcaObjectProperties {
    private boolean nullUIInfoLogged = false;
    protected static final ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
    private ObjectId objectId = null;
    PropertyChangeSupport propertyChangeSupport;
    protected UIInfo uiInfo = null;
    protected boolean root = false;
    protected boolean persistent = false;
    protected boolean autoPersist = true;
    private String persistKey = null;
    private Object propertyChangeMonitor = new Object();
    private Object persistMonitor = new Object();
    private static final FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(85, "HwmcaObject");
    private static final String TRACE_MASKT = "XFRMOBJT";
    private static final String TRACE_MASKF = "XFRMOBJF";
    private static final String TRACE_MASKD = "XFRMOBJD";
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Object;

    protected HwmcaObject() {
        this.objectId = new ObjectId(this);
        this.propertyChangeSupport = new PropertyChangeSupport();
    }

    protected HwmcaObject(PersistentData data, String persistKey) {
        this();
        this.persistKey = persistKey;
        this.objectId = new ObjectId(((Persistent)data).objectId);
        this.uiInfo = ((Persistent)data).uiInfo;
        this.root = ((Persistent)data).root;
        this.persistent = true;
        this.propertyChangeSupport = new PropertyChangeSupport();
    }

    public Object getProperty(String propertyName) throws NoSuchMethodException, InvocationTargetException {
        Trace.trace(TRACE_MASKT, "<> getProperty(propertyName=" + propertyName + ")");
        Object result = null;
        Class<?> thisClass = this.getClass();
        StringBuffer methodName = new StringBuffer("get").append(propertyName);
        Method method = this.findMethod(thisClass, methodName.toString(), null);
        if (method == null && (method = this.findMethod(thisClass, (methodName = new StringBuffer("is").append(propertyName)).toString(), null)) == null) {
            throw new NoSuchMethodException("Methods get" + propertyName + "() or is" + propertyName + "() do not exist for class " + thisClass);
        }
        try {
            result = method.invoke((Object)this, null);
        }
        catch (IllegalAccessException exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
        return result;
    }

    public void setProperty(String propertyName, Object newValue) throws NoSuchMethodException, InvocationTargetException {
        Trace.trace(TRACE_MASKT, "<> setProperty(propertyName=" + propertyName + ")");
        Class<?> thisClass = this.getClass();
        StringBuffer methodName = new StringBuffer("set").append(propertyName);
        Method method = this.findMethod(thisClass, methodName.toString(), newValue.getClass());
        if (method == null) {
            throw new NoSuchMethodException("Method " + methodName + "(" + newValue.getClass() + ") does not exist for class " + thisClass);
        }
        try {
            Object[] setArg = new Object[]{newValue};
            method.invoke((Object)this, setArg);
        }
        catch (IllegalAccessException exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
    }

    public Map getProperties(String[] propertyNames) throws NoSuchMethodException, InvocationTargetException {
        Trace.trace(TRACE_MASKT, "-> getProperties()");
        HashMap<String, Object> result = new HashMap<String, Object>();
        int ix = 0;
        while (ix < propertyNames.length) {
            result.put(propertyNames[ix], this.getProperty(propertyNames[ix]));
            ++ix;
        }
        Trace.trace(TRACE_MASKT, "<- getProperties()");
        return result;
    }

    public void setProperties(Map properties) throws NoSuchMethodException, InvocationTargetException {
        Trace.trace(TRACE_MASKT, "-> setProperties()");
        Iterator iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry property = iterator.next();
            this.setProperty((String)property.getKey(), property.getValue());
        }
        Trace.trace(TRACE_MASKT, "<- setProperties()");
    }

    public ObjectId getObjectId() {
        return this.objectId;
    }

    public UIInfo getUIInfo() {
        UIInfo result = null;
        if (this.uiInfo != null) {
            result = (UIInfo)this.uiInfo.clone();
        } else if (!this.nullUIInfoLogged) {
            this.nullUIInfoLogged = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUIInfo(UIInfo uiInfo) {
        Trace.trace(TRACE_MASKT, "-> setUIInfo(uiInfo=" + uiInfo + ")");
        if (uiInfo == null) {
            IllegalArgumentException exc = new IllegalArgumentException("uiInfo argument is null");
            Trace.trace(TRACE_MASKF, exc);
            exc.printStackTrace();
        }
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            UIInfo oldValue = this.uiInfo;
            this.uiInfo = uiInfo;
            this.firePropertyChange("UIInfo", oldValue, uiInfo);
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKT, "<- setUIInfo()");
    }

    public boolean isRoot() {
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRoot(boolean root) {
        Trace.trace(TRACE_MASKT, "-> setRoot(root=" + root + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            boolean oldRoot = this.root;
            this.root = root;
            this.firePropertyChange("Root", oldRoot, root);
        }
        this.autoPersist();
        Trace.trace(TRACE_MASKT, "<- setRoot()");
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPersistent(boolean persistent) {
        Trace.trace(TRACE_MASKT, "-> setPersistent(persistent=" + persistent + ")");
        Object object = this.getPropertyChangeMonitor();
        synchronized (object) {
            boolean oldPersistent = this.persistent;
            this.persistent = persistent;
            this.firePropertyChange("Persistent", oldPersistent, persistent);
        }
        Trace.trace(TRACE_MASKT, "<- setPersistent()");
    }

    public boolean isAutoPersist() {
        return this.autoPersist;
    }

    public Object setAutoPersist(boolean autoPersist) {
        Trace.trace(TRACE_MASKT, "<> setAutoPersist(autoPersist=" + autoPersist + ")");
        this.autoPersist = autoPersist;
        return this.persistMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist() throws PersistenceException {
        Trace.trace(TRACE_MASKT, "-> persist()");
        Object object = this.persistMonitor;
        synchronized (object) {
            this.setAutoPersist(true);
            if (this.isPersistent()) {
                PersistenceManager manager = PersistenceManager.getPersistenceManager();
                String key = this.getPersistKey();
                if (key == null) {
                    this.persistKey = manager.writeChild(this.getPersistenceNamespace(), this);
                } else {
                    manager.write(key, this);
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- persist()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpersist() {
        Trace.trace(TRACE_MASKT, "-> unpersist()");
        Object object = this.persistMonitor;
        synchronized (object) {
            String key = this.getPersistKey();
            if (this.isPersistent() && key != null) {
                PersistenceManager.getPersistenceManager().delete(key);
            }
        }
        Trace.trace(TRACE_MASKT, "<- unpersist()");
    }

    public String getPersistenceNamespace() {
        return this.getClass().getName();
    }

    public String getPersistKey() {
        return this.persistKey;
    }

    public PersistentData getPersistentData() {
        Persistent result = new Persistent();
        result.objectId = this.objectId.getPersistentData();
        result.uiInfo = this.uiInfo;
        result.root = this.root;
        return result;
    }

    public boolean isUpgradeData() {
        return false;
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        Trace.trace(TRACE_MASKT, "<> HwmcaObject.addPropertyChangeListener(propertyName=" + propertyName + ",listener=" + listener + ")");
        this.propertyChangeSupport.addPropertyChangeListener(new ListenerInfo(propertyName, listener));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        Trace.trace(TRACE_MASKT, "<> HwmcaObject.addPropertyChangeListener(listener=" + listener + ")");
        this.propertyChangeSupport.addPropertyChangeListener(new ListenerInfo(listener));
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        Trace.trace(TRACE_MASKT, "<> HwmcaObject.removePropertyChangeListener(propertyName=" + propertyName + ",listener=" + listener + ")");
        this.propertyChangeSupport.removePropertyChangeListener(new ListenerInfo(propertyName, listener));
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        Trace.trace(TRACE_MASKT, "<> HwmcaObject.removePropertyChangeListener(listener=" + listener + ")");
        this.propertyChangeSupport.removePropertyChangeListener(new ListenerInfo(listener));
    }

    public static HwmcaObject[] getObjectsFromIds(ObjectId[] objectIds, Class arrayType) {
        HwmcaObject[] result = null;
        if (objectIds != null && (arrayType != null || objectIds.length > 0)) {
            int start = 0;
            int count = objectIds.length;
            HwmcaObject first = null;
            if (arrayType == null) {
                start = 1;
                first = mom.get(objectIds[0]);
                if (first != null) {
                    arrayType = first.getClass();
                }
            }
            if (arrayType != null) {
                result = (HwmcaObject[])Array.newInstance(arrayType, count);
                if (count > 0) {
                    result[0] = first;
                    int ix = start;
                    while (ix < count) {
                        result[ix] = mom.get(objectIds[ix]);
                        ++ix;
                    }
                }
            }
        }
        return result;
    }

    public static HwmcaObject[] getObjectsFromIds(ObjectId[] objectIds) {
        return HwmcaObject.getObjectsFromIds(objectIds, null);
    }

    public static ObjectId[] getIdsFromObjects(HwmcaObject[] objects) {
        ObjectId[] result = null;
        if (objects != null) {
            int count = objects.length;
            result = new ObjectId[count];
            int ix = 0;
            while (ix < count) {
                if (objects[ix] != null) {
                    result[ix] = objects[ix].getObjectId();
                }
                ++ix;
            }
        }
        return result;
    }

    public String toString() {
        ObjectId objectId = this.getObjectId();
        return objectId == null ? "null" : objectId.toString();
    }

    protected Object getPropertyChangeMonitor() {
        return this.propertyChangeMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void autoPersist() {
        if (this.isPersistent()) {
            Object object = this.persistMonitor;
            synchronized (object) {
                if (this.isAutoPersist()) {
                    Trace.trace(TRACE_MASKT, "-> autoPersist()");
                    try {
                        PersistenceManager manager = PersistenceManager.getPersistenceManager();
                        String key = this.getPersistKey();
                        if (key == null) {
                            this.persistKey = manager.writeChild(this.getPersistenceNamespace(), this);
                        } else {
                            manager.write(key, this);
                        }
                    }
                    catch (PersistenceException exc) {
                        new FrameworkLog(logInfo, 1029, exc).log();
                    }
                    Trace.trace(TRACE_MASKT, "<- autoPersist()");
                }
            }
        }
    }

    protected void setObjectId(ObjectId objectId) {
        Trace.trace(TRACE_MASKT, "<> setObjectId(objectId=" + objectId + ")");
        if (objectId == null) {
            throw new IllegalArgumentException("Object Id cannot be null");
        }
        this.objectId = objectId;
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        Trace.trace(TRACE_MASKD, "<> firePropertyChange(propertyName=" + propertyName + ")");
        PropertyChangeEvent event = new PropertyChangeEvent(this.getObjectId(), propertyName, oldValue, newValue);
        this.propertyChangeSupport.firePropertyChange(event);
    }

    protected void firePropertyChange(String propertyName, int oldValue, int newValue) {
        Trace.trace(TRACE_MASKD, "<> firePropertyChange(propertyName=" + propertyName + ",oldValue=" + oldValue + ",newValue=" + newValue + ")");
        PropertyChangeEvent event = new PropertyChangeEvent(this.getObjectId(), propertyName, new Integer(oldValue), new Integer(newValue));
        this.propertyChangeSupport.firePropertyChange(event);
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        Trace.trace(TRACE_MASKD, "<> firePropertyChange(propertyName=" + propertyName + ",oldValue=" + oldValue + ",newValue=" + newValue + ")");
        PropertyChangeEvent event = new PropertyChangeEvent(this.getObjectId(), propertyName, new Boolean(oldValue), new Boolean(newValue));
        this.propertyChangeSupport.firePropertyChange(event);
    }

    protected void fireContainerPropertyAdd(String propertyName, Object addedValues) {
        Trace.trace(TRACE_MASKD, "<> fireContainerPropertyAdd(propertyName=" + propertyName + ")");
        PropertyChangeEvent event = new PropertyChangeEvent(this.getObjectId(), propertyName, null, addedValues);
        this.propertyChangeSupport.firePropertyChange(event);
    }

    protected void fireContainerPropertyRemove(String propertyName, Object removedValues) {
        Trace.trace(TRACE_MASKD, "<> fireContainerPropertyRemove(propertyName=" + propertyName + ")");
        PropertyChangeEvent event = new PropertyChangeEvent(this.getObjectId(), propertyName, removedValues, null);
        this.propertyChangeSupport.firePropertyChange(event);
    }

    protected Object hashedGetProperty(String propertyName, Map methodMap) throws NoSuchMethodException, InvocationTargetException {
        Object result = null;
        StringBuffer methodName = new StringBuffer("get").append(propertyName);
        Method method = (Method)methodMap.get(methodName);
        if (method == null) {
            methodName = new StringBuffer("is").append(propertyName);
            method = (Method)methodMap.get(methodName);
        }
        if (method == null) {
            Class<?> thisClass = this.getClass();
            method = this.findMethod(thisClass, (methodName = new StringBuffer("get").append(propertyName)).toString(), null);
            if (method == null && (method = this.findMethod(thisClass, (methodName = new StringBuffer("is").append(propertyName)).toString(), null)) == null) {
                throw new NoSuchMethodException("Methods get" + propertyName + "() or is" + propertyName + "() do not exist for class " + thisClass);
            }
            methodMap.put(methodName, method);
        }
        try {
            result = method.invoke((Object)this, null);
        }
        catch (IllegalAccessException exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
        return result;
    }

    public void hashedSetProperty(String propertyName, Object newValue, Map methodMap) throws NoSuchMethodException, InvocationTargetException {
        StringBuffer methodName = new StringBuffer("set").append(propertyName);
        Method method = (Method)methodMap.get(methodName);
        if (method == null) {
            Class<?> thisClass = this.getClass();
            method = this.findMethod(thisClass, methodName.toString(), newValue.getClass());
            if (method == null) {
                throw new NoSuchMethodException("Method " + methodName + "(" + newValue.getClass() + ") does not exist for class " + thisClass);
            }
            methodMap.put(methodName, method);
        }
        try {
            Object[] setArg = new Object[]{newValue};
            method.invoke((Object)this, setArg);
        }
        catch (IllegalAccessException exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
    }

    private Method findMethod(Class aClass, String name, Class argType) throws NoSuchMethodException {
        Method result = null;
        Method[] methods = aClass.getDeclaredMethods();
        int ix = 0;
        while (ix < methods.length && result == null) {
            if (name.equals(methods[ix].getName()) && Modifier.isPublic(methods[ix].getModifiers())) {
                Class<?>[] types = methods[ix].getParameterTypes();
                if (argType == null) {
                    if (types.length == 0) {
                        result = methods[ix];
                    }
                } else if (types.length == 1) {
                    if (types[0].isPrimitive()) {
                        if (types[0] == Boolean.TYPE) {
                            types[0] = class$java$lang$Boolean == null ? HwmcaObject.class$("java.lang.Boolean") : class$java$lang$Boolean;
                        } else if (types[0] == Byte.TYPE) {
                            types[0] = class$java$lang$Byte == null ? HwmcaObject.class$("java.lang.Byte") : class$java$lang$Byte;
                        } else if (types[0] == Short.TYPE) {
                            types[0] = class$java$lang$Short == null ? HwmcaObject.class$("java.lang.Short") : class$java$lang$Short;
                        } else if (types[0] == Integer.TYPE) {
                            types[0] = class$java$lang$Integer == null ? HwmcaObject.class$("java.lang.Integer") : class$java$lang$Integer;
                        } else if (types[0] == Long.TYPE) {
                            types[0] = class$java$lang$Long == null ? HwmcaObject.class$("java.lang.Long") : class$java$lang$Long;
                        } else if (types[0] == Float.TYPE) {
                            types[0] = class$java$lang$Float == null ? HwmcaObject.class$("java.lang.Float") : class$java$lang$Float;
                        } else if (types[0] == Double.TYPE) {
                            types[0] = class$java$lang$Double == null ? HwmcaObject.class$("java.lang.Double") : class$java$lang$Double;
                        } else if (types[0] == Character.TYPE) {
                            Class clazz = types[0] = class$java$lang$Character == null ? HwmcaObject.class$("java.lang.Character") : class$java$lang$Character;
                        }
                    }
                    if (types[0].isAssignableFrom(argType)) {
                        result = methods[ix];
                    }
                }
            }
            ++ix;
        }
        if (result == null && aClass != (class$java$lang$Object == null ? (class$java$lang$Object = HwmcaObject.class$("java.lang.Object")) : class$java$lang$Object)) {
            result = this.findMethod(aClass.getSuperclass(), name, argType);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class PropertyChangeSupport {
        private static final boolean DEBUG = false;
        private ArrayList listeners = new ArrayList();
        private Object listenersMonitor = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addPropertyChangeListener(ListenerInfo info) {
            Object object = this.listenersMonitor;
            synchronized (object) {
                this.listeners.add(info);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ListenerInfo removePropertyChangeListener(ListenerInfo info) {
            ListenerInfo result = null;
            Object object = this.listenersMonitor;
            synchronized (object) {
                Iterator iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    ListenerInfo listInfo = (ListenerInfo)iterator.next();
                    if (!listInfo.equals(info)) continue;
                    result = listInfo;
                    iterator.remove();
                    break;
                }
            }
            return result;
        }

        public void firePropertyChange(PropertyChangeEvent event) {
            if (!(event.getOldValue() == null && event.getNewValue() == null || event.getOldValue() != null && event.getOldValue().equals(event.getNewValue()))) {
                HashSet<PropertyChangeListener> listeners = new HashSet<PropertyChangeListener>();
                Iterator iterator = this.getListeners().iterator();
                while (iterator.hasNext()) {
                    ListenerInfo info = (ListenerInfo)iterator.next();
                    if (!info.isApplicable(event)) continue;
                    listeners.add(info.getListener());
                }
                Iterator iterator2 = listeners.iterator();
                while (iterator2.hasNext()) {
                    PropertyChangeListener listener = (PropertyChangeListener)iterator2.next();
                    try {
                        Trace.trace(HwmcaObject.TRACE_MASKF, "Firing " + event.getPropertyName() + " property change event from " + event.getSource() + " to " + listener);
                        listener.propertyChange(event);
                    }
                    catch (Exception exc) {
                        Trace.trace(HwmcaObject.TRACE_MASKF, "Exception caught sending property change event to " + listener);
                        Trace.trace(HwmcaObject.TRACE_MASKF, exc);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasListeners() {
            Object object = this.listenersMonitor;
            synchronized (object) {
                return this.listeners.size() > 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List getListeners() {
            Object object = this.listenersMonitor;
            synchronized (object) {
                return (List)this.listeners.clone();
            }
        }
    }

    static class ListenerInfo {
        String propertyName;
        PropertyChangeListener listener;

        public ListenerInfo(String propertyName, PropertyChangeListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("Listener must not be null");
            }
            this.propertyName = propertyName;
            this.listener = listener;
        }

        public ListenerInfo(PropertyChangeListener listener) {
            this(null, listener);
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public PropertyChangeListener getListener() {
            return this.listener;
        }

        public boolean isApplicable(PropertyChangeEvent event) {
            return this.getPropertyName() == null || this.getPropertyName().equals(event.getPropertyName());
        }

        public boolean equals(Object test) {
            boolean result = false;
            if (test instanceof ListenerInfo) {
                ListenerInfo testInfo = (ListenerInfo)test;
                String testPropertyName = ((ListenerInfo)test).propertyName;
                PropertyChangeListener testListener = ((ListenerInfo)test).listener;
                result = (this.propertyName == null && testPropertyName == null || this.propertyName != null && this.propertyName.equals(testPropertyName)) && this.listener.equals(testListener);
            }
            return result;
        }

        public String toString() {
            StringBuffer result = new StringBuffer(this.getClass().getName()).append("[propertyName=").append(this.getPropertyName()).append(",listener=").append(this.getListener()).append("]");
            return result.toString();
        }
    }

    private static class Persistent
    implements PersistentData {
        int version = 0;
        PersistentData objectId;
        UIInfo uiInfo;
        boolean root;
        private static final long serialVersionUID = 2707895156626704990L;

        private Persistent() {
        }
    }
}

